/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console;

import filenet.sim.api.IVWSIMSimulation;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMConsoleActionCommand;
import filenet.sim.toolkit.console.images.VWSIMImageLoader;
import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMItem;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;

public class VWSIMSimulationNode
extends VWSIMBaseNode {
    public static final int SIMULATION_STATUS_INIT = 0;
    public static final int SIMULATION_STATUS_RUNNING = 1;
    public static final int SIMULATION_STATUS_STOPPED = 3;
    public static final int SIMULATION_STATUS_COMPLETED = 4;
    public static final int SIMULATION_STATUS_ERROR = -1;
    private static final ImageIcon simulationIcon16 = VWSIMImageLoader.createImageIcon("simulation_16.gif");
    private IVWSIMSimulation m_IVWSIMSimulation = null;
    private VWSIMBaseNode m_parentFolder = null;
    private int m_status = -1;
    private boolean m_bCollectAnalysisData = false;
    private Date m_dateCreated = null;
    private Date m_dateLaterModified = null;
    private String m_creator = null;
    private IVWIDMDocument m_idmDocument = null;
    private Boolean m_bCanViewContent = null;

    public VWSIMSimulationNode(IVWIDMItem aIDMItem, IVWSIMSimulation ivwSimSimulation, VWSIMBaseNode parentFolder) {
        super(aIDMItem, 34, VWSIMConsoleActionCommand.ACMD_SIMULATION);
        try {
            this.setIcon16(simulationIcon16);
            this.m_parentFolder = parentFolder;
            this.m_IVWSIMSimulation = ivwSimSimulation;
            this.m_status = this.m_IVWSIMSimulation.getStatus();
            this.setName(this.m_IVWSIMSimulation.getName());
            IVWIDMDocument aIVWIDMDocument = (IVWIDMDocument)aIDMItem;
            Boolean bProp = (Boolean)aIVWIDMDocument.getProp("PublishingEnabled");
            this.m_bCollectAnalysisData = bProp;
            GregorianCalendar gcl = this.m_IVWSIMSimulation.getDateCreated();
            this.m_dateCreated = gcl.getTime();
            gcl = this.m_IVWSIMSimulation.getDateLastModified();
            this.m_dateLaterModified = gcl.getTime();
            this.m_creator = this.m_IVWSIMSimulation.getCreator();
            this.m_idmDocument = this.m_IVWSIMSimulation.getIDMDocument();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public TreeNode getParent() {
        return this.m_parentFolder;
    }

    public TreeNode getRoot() {
        if (this.m_parentFolder != null) {
            return this.m_parentFolder.getRoot();
        }
        return null;
    }

    public IVWSIMSimulation getSIMSimulation() {
        return this.m_IVWSIMSimulation;
    }

    public void setSIMSimulation(IVWSIMSimulation ivwSimSimulation) {
        this.m_IVWSIMSimulation = ivwSimSimulation;
    }

    public String getSimulationId() {
        return this.m_IVWSIMSimulation.getSimulationDocId();
    }

    public String getSimulationName() {
        String simName = null;
        try {
            simName = this.m_IVWSIMSimulation.getName();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return simName;
    }

    public VWScenarioDefinition getSIMScenarioDefinition() {
        VWScenarioDefinition aScnDef = null;
        try {
            aScnDef = this.m_IVWSIMSimulation.getScenariodefinition();
        }
        catch (Exception ex) {
            this.displayMessage(3, ex.getLocalizedMessage());
            VWDebug.logException(ex);
        }
        return aScnDef;
    }

    public void refresh() throws Exception {
        try {
            this.m_IVWSIMSimulation.refresh();
            this.setName(this.m_IVWSIMSimulation.getName());
            this.m_status = this.m_IVWSIMSimulation.getStatus();
            if (this.m_status == -1) {
                String errmsg = this.m_IVWSIMSimulation.getSimulationFailureMessage();
                this.displayMessage(3, errmsg);
            }
            this.m_bCanViewContent = new Boolean(this.m_idmDocument.canOpen());
        }
        catch (Exception ex) {
            this.displayMessage(3, ex.getLocalizedMessage());
            throw ex;
        }
    }

    public int getStatus() {
        return this.m_status;
    }

    public boolean canViewContent() {
        if (this.m_bCanViewContent == null) {
            this.m_bCanViewContent = new Boolean(this.m_idmDocument.canOpen());
        }
        return this.m_bCanViewContent;
    }

    public boolean isCollectAnalysisData() {
        return this.m_bCollectAnalysisData;
    }

    public Date getDateCreated() {
        return this.m_dateCreated;
    }

    public Date getDateLastModified() {
        return this.m_dateLaterModified;
    }

    public String getCreator() {
        return this.m_creator;
    }

    public void stopSimulation() throws Exception {
        this.m_IVWSIMSimulation.stop();
        this.displayMessage(1, VWSIMResource.StopSimulationMsg.toString(this.getSimulationName(), this.getSimulationId()));
    }

    public void deleteSimulation() throws Exception {
        try {
            this.m_IVWSIMSimulation.stop();
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.m_IVWSIMSimulation.deleteSimulation();
    }

    public void releaseResources() {
        this.m_IVWSIMSimulation = null;
        this.m_parentFolder = null;
        this.m_dateCreated = null;
        this.m_dateLaterModified = null;
        this.m_creator = null;
        this.m_idmDocument = null;
        this.m_bCanViewContent = null;
        super.releaseResources();
    }
}

